//=============================================================================
// PetPerkButton
//=============================================================================
class CCColorButton extends PersonaBorderButtonWindow;

#exec TEXTURE IMPORT NAME="CCMBlack" FILE="Textures\CCMBlack.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMDGray" FILE="Textures\CCMDGray.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMGray" FILE="Textures\CCMGray.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMWhite" FILE="Textures\CCMWhite.pcx" GROUP=Skins

#exec TEXTURE IMPORT NAME="CCMRed" FILE="Textures\CCMRed.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMOrange" FILE="Textures\CCMOrange.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMGold" FILE="Textures\CCMYellow.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMGreen" FILE="Textures\CCMGreen.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMBlue" FILE="Textures\CCMBlue.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CCMPurple" FILE="Textures\CCMPurple.pcx" GROUP=Skins FLAGS=2


#exec TEXTURE IMPORT NAME="ColorButton1" FILE="Textures\ColorButton1.pcx" GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME="ColorButton2" FILE="Textures\ColorButton2.pcx" GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME="ColorButton3" FILE="Textures\ColorButton3.pcx" GROUP=Skins FLAGS=2

//#exec TEXTURE IMPORT NAME="TestTex" FILE="Textures\TestTex.pcx" GROUP=Skins

var int MS;
var Texture ColorTex[10];

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

event StyleChanged()
{
 bTranslucent = False;
}

function SetTextures(Texture Tex)
{
     Left_Textures[0].Tex = Tex;
     Left_Textures[1].Tex = Tex;
     //Right_Textures[0].Tex = Tex;
     //Right_Textures[1].Tex = Tex;
     //Center_Textures[0].Tex = Tex;
     //Center_Textures[1].Tex = Tex;
}

function UpdateColor(int i, optional bool bSP)
{
	if (bSP)
	{
	 if (i == 0) SetTextures(Texture'CCMBlack');
	 if (i == 1) SetTextures(Texture'CCMDGray');
	 if (i == 2) SetTextures(Texture'CCMGray');
	 if (i == 3) SetTextures(Texture'CCMWhite');
	 if (i == 4) SetTextures(Texture'CCMRed');
	 if (i == 5) SetTextures(Texture'CCMOrange');
	 if (i == 6) SetTextures(Texture'CCMGold');
	 if (i == 7) SetTextures(Texture'CCMGreen');
	 if (i == 8) SetTextures(Texture'CCMBlue');
	 if (i == 9) SetTextures(Texture'CCMPurple');
	}
	
	if (!bSP)
	{
	 if (i == 1) SetTextures(Texture'ColorButton1');
	 if (i == 2) SetTextures(Texture'ColorButton2');
	 if (i == 3) SetTextures(Texture'ColorButton3');
	}
	
//	SetTextures(Texture'TestTex');
//	SetTextures(Texture'CCMPurple');
}

defaultproperties
{
     ColorTex(0)=Texture'CCMBlack'
     ColorTex(1)=Texture'CCMDGray'
     ColorTex(2)=Texture'CCMGray'
     ColorTex(3)=Texture'CCMWhite'
     ColorTex(4)=Texture'CCMRed'
     ColorTex(5)=Texture'CCMOrange'
     ColorTex(6)=Texture'CCMGold'
     ColorTex(7)=Texture'CCMGreen'
     ColorTex(8)=Texture'CCMBlue'
     ColorTex(9)=Texture'CCMPurple'
     
     Left_Textures(0)=(Tex=Texture'DeusExUI.UserInterface.PersonaActionButtonNormal_Left',Width=32)
     Left_Textures(1)=(Tex=Texture'DeusExUI.UserInterface.PersonaActionButtonPressed_Left',Width=32)
     Right_Textures(0)=(Tex=Texture'PinkMaskTex',Width=0)
     Right_Textures(1)=(Tex=Texture'PinkMaskTex',Width=0)
     Center_Textures(0)=(Tex=Texture'PinkMaskTex',Width=0)
     Center_Textures(1)=(Tex=Texture'PinkMaskTex',Width=0)
     buttonHeight=32
     minimumButtonWidth=0
}
